<?php

namespace Google\Site_Kit_Dependencies;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * The "segments" collection of methods.
 * Typical usage is:
 *  <code>
 *   $analyticsService = new Google_Service_Analytics(...);
 *   $segments = $analyticsService->segments;
 *  </code>
 */
class Google_Service_Analytics_Resource_ManagementSegments extends \Google\Site_Kit_Dependencies\Google_Service_Resource
{
    /**
     * Lists segments to which the user has access.
     * (segments.listManagementSegments)
     *
     * @param array $optParams Optional parameters.
     *
     * @opt_param int start-index An index of the first segment to retrieve. Use
     * this parameter as a pagination mechanism along with the max-results
     * parameter.
     * @opt_param int max-results The maximum number of segments to include in this
     * response.
     * @return Google_Service_Analytics_Segments
     */
    public function listManagementSegments($optParams = array())
    {
        $params = array();
        $params = \array_merge($params, $optParams);
        return $this->call('list', array($params), "Google\Site_Kit_Dependencies\Google_Service_Analytics_Segments");
    }
}
