<?php

/**
 * Blog Kit functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Blog_Kit
 */
if ( !function_exists( 'blog_kit_setup' ) ) {
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function blog_kit_setup()
    {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on Blog Kit, use a find and replace
         * to change 'blog-kit' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'blog-kit', get_template_directory() . '/languages' );
        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );
        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );
        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'primary' => esc_html__( 'Primary', 'blog-kit' ),
            'social'  => esc_html__( 'Social', 'blog-kit' ),
        ) );
        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption'
        ) );
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );
        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );
        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );
        // Add support for responsive embedded content.
        add_theme_support( 'responsive-embeds' );
        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'blog_kit_custom_background_args', array(
            'default-color' => 'edeff2',
            'default-image' => '',
        ) ) );
        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support( 'custom-logo', array(
            'height'      => 250,
            'width'       => 250,
            'flex-width'  => true,
            'flex-height' => true,
        ) );
    }

}
add_action( 'after_setup_theme', 'blog_kit_setup' );
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function blog_kit_content_width()
{
    // This variable is intended to be overruled from themes.
    // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $GLOBALS['content_width'] = apply_filters( 'blog_kit_content_width', 640 );
}

add_action( 'after_setup_theme', 'blog_kit_content_width', 0 );
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function blog_kit_widgets_init()
{
    register_sidebar( array(
        'name'          => esc_html__( 'Primary Sidebar', 'blog-kit' ),
        'id'            => 'sidebar-1',
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    for ( $i = 1 ;  $i <= 4 ;  $i++ ) {
        register_sidebar( array(
            'name'          => sprintf( esc_html__( 'Footer Sidebar %d', 'blog-kit' ), $i ),
            'id'            => 'footer-' . $i,
            'before_widget' => '<div id="%1$s" class="widget footer-widgets %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
    }
}

add_action( 'widgets_init', 'blog_kit_widgets_init' );
/**
 * Enqueue scripts and styles.
 */
function blog_kit_scripts()
{
    wp_enqueue_style(
        'blog-kit-fonts',
        blog_kit_fonts_url(),
        array(),
        null
    );
    wp_enqueue_style( 'jquery-meanmenu', get_template_directory_uri() . '/assets/meanmenu/meanmenu.css' );
    wp_enqueue_style(
        'font-awesome',
        get_template_directory_uri() . '/assets/font-awesome/css/font-awesome.min.css',
        '',
        '4.7.0'
    );
    wp_enqueue_style( 'blog-kit-style', get_stylesheet_uri() );
    wp_enqueue_script(
        'blog-kit-navigation',
        get_template_directory_uri() . '/assets/js/navigation.js',
        array(),
        '20151215',
        true
    );
    wp_enqueue_script(
        'blog-kit-skip-link-focus-fix',
        get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js',
        array(),
        '20151215',
        true
    );
    wp_enqueue_script(
        'jquery-meanmenu',
        get_template_directory_uri() . '/assets/meanmenu/jquery.meanmenu.js',
        array( 'jquery' ),
        '2.0.2',
        true
    );
    wp_enqueue_script(
        'blog-kit-custom',
        get_template_directory_uri() . '/assets/js/custom.js',
        array( 'jquery' ),
        '2.0.3',
        true
    );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

add_action( 'wp_enqueue_scripts', 'blog_kit_scripts' );
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
 * Load theme info and demo content pages.
 */

if ( is_admin() ) {
    // Load theme info pages.
    require_once trailingslashit( get_template_directory() ) . 'inc/theme-info/class-about.php';
    require_once trailingslashit( get_template_directory() ) . 'inc/theme-info/about.php';
    // Load demo content.
    require_once trailingslashit( get_template_directory() ) . 'inc/demo/class-demo.php';
    require_once trailingslashit( get_template_directory() ) . 'inc/demo/demo.php';
}

/**
 * TGM Plugin activation.
 */
require_once trailingslashit( get_template_directory() ) . '/inc/class-tgm-plugin-activation.php';
// Load metabox.
require_once trailingslashit( get_template_directory() ) . '/inc/metabox.php';
/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require get_template_directory() . '/inc/jetpack.php';
}
/**
 * Load dynamic CSS.
 */
require_once trailingslashit( get_template_directory() ) . '/inc/dynamic-styles.php';
//add freemius

if ( !function_exists( 'blog_kit_fs' ) ) {
    // Create a helper function for easy SDK access.
    function blog_kit_fs()
    {
        global  $blog_kit_fs ;
        
        if ( !isset( $blog_kit_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/freemius/start.php';
            $blog_kit_fs = fs_dynamic_init( array(
                'id'              => '4204',
                'slug'            => 'blog-kit',
                'premium_slug'    => 'blog-kit-pro',
                'type'            => 'theme',
                'public_key'      => 'pk_70af778e6698f5f09ba05e67fa410',
                'is_premium'      => true,
                'is_premium_only' => true,
                'has_addons'      => false,
                'has_paid_plans'  => true,
                'menu'            => array(
                'slug'    => 'blog-kit-pro-about',
                'support' => false,
                'parent'  => array(
                'slug' => 'themes.php',
            ),
            ),
                'is_live'         => true,
            ) );
        }
        
        return $blog_kit_fs;
    }
    
    // Init Freemius.
    blog_kit_fs();
    // Signal that SDK was initiated.
    do_action( 'blog_kit_fs_loaded' );
}
