<?php
/**
 * Blog Kit Theme Customizer
 *
 * @package Blog_Kit
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

global $blog_kit_google_fonts;

$blog_kit_google_fonts = array(
    'Open+Sans:400,400italic,600,700'                               => 'Open Sans',
    'Roboto:400,500,300,700,400italic'                              => 'Roboto',
    'Lato:400,300,400italic,900,700'                                => 'Lato',
    'Barlow:300,300i,400,400i,500,500i,600,600i,700,700i,800,800i'  => 'Barlow',
    'Slabo+27px'                                                    => 'Slabo 27px',
    'Domine:400,700'                                                => 'Domine',
    'Oswald:400,300,700'                                            => 'Oswald',
    'Roboto+Condensed:400,300,400italic,700'                        => 'Roboto Condensed',
    'Source+Sans+Pro:400,400italic,600,900,300'                     => 'Source Sans Pro',
    'Lora:400,400italic,700,700italic'                              => 'Lora',
    'Montserrat:300,400,500,600,700'                                => 'Montserrat',
    'PT+Sans:400,400italic,700'                                     => 'PT Sans',
    'Open+Sans+Condensed:300,300italic,700'                         => 'Open Sans Condensed',
    'Raleway:400,300,500,600,700,900'                               => 'Raleway',
    'Droid+Sans:400,700'                                            => 'Droid Sans',
    'Ubuntu:400,400italic,500,700'                                  => 'Ubuntu',
    'Droid+Serif:400,400italic,700'                                 => 'Droid Serif',
    'Roboto+Slab:400,300,700'                                       => 'Roboto Slab',
    'Arimo:400,400italic,700'                                       => 'Arimo',
    'Merriweather:400,400italic,300,900,700'                        => 'Merriweather',
    'PT+Sans+Narrow:400,700'                                        => 'PT Sans Narrow',
    'Poiret+One'                                                    => 'Poiret One',
    'Noto +Sans:400,400italic,700'                                  => 'Noto Sans',
    'Titillium+Web:400,300,400italic,700,900'                       => 'Titillium Web',
    'PT+Serif:400,400italic,700'                                    => 'PT Serif',
    'Bitter:400,400italic,700'                                      => 'Bitter',
    'Indie+Flower'                                                  => 'Indie Flower',
    'Yanone+Kaffeesatz:400,300,700'                                 => 'Yanone Kaffeesatz',
    'Dosis:400,300,600,800'                                         => 'Dosis',
    'Arvo:400,400italic,700'                                        => 'Arvo',
    'Lobster'                                                       => 'Lobster',
    'Cabin:400,400italic,500,600,700'                               => 'Cabin',
    'Fjalla+One'                                                    => 'Fjalla One',
    'Oxygen:400,300,700'                                            => 'Oxygen',
    'Playfair+Display:400,400italic,700,900'                        => 'Playfair Display',
    'Noto +Serif:400,400italic,700'                                 => 'Noto Serif',
    'Hind:400,300,600,700'                                          => 'Hind',
    'Muli:400,300italic,300'                                        => 'Muli',
    'Nunito:400,300,700'                                            => 'Nunito',
    'Bree+Serif'                                                    => 'Bree Serif',
    'Abel'                                                          => 'Abel',
    'Vollkorn:400,400italic,700'                                    => 'Vollkorn',
    'Inconsolata:400,700'                                           => 'Inconsolata',
    'Francois+One'                                                  => 'Francois One',
    'Archivo+Narrow:400,400italic,700'                              => 'Archivo Narrow',
    'Ubuntu+Condensed'                                              => 'Ubuntu Condensed',
    'Josefin+Sans:400,600,700,400italic'                            => 'Josefin Sans',
    'Fira+Sans:400,500'                                             => 'Fira Sans',
    'Signika:400,300,700'                                           => 'Signika',
    'Libre+Baskerville:400,400italic,700'                           => 'Libre Baskerville',
    'Cuprum:400,400italic'                                          => 'Cuprum',
    'Play:400,700'                                                  => 'Play',
    'Pacifico'                                                      => 'Pacifico',
    'Shadows+Into+Light'                                            => 'Shadows Into Light',
    'Asap:400,400italic,700'                                        => 'Asap',
    'Alegreya:400,400italic,700,900'                                => 'Alegreya',
    'Maven+Pro:400,500,700,900'                                     => 'Maven Pro',
    'Exo +2:400,300,400italic,600,700,900'                          => 'Exo 2',
    'Sigmar+One'                                                    => 'Sigmar One',
    'Merriweather+Sans:400,400italic,700,800'                       => 'Merriweather Sans',
    'Crimson+Text:400,400italic,600,700'                            => 'Crimson Text',
    'Anton'                                                         => 'Anton',
    'Rokkitt:400,700'                                               => 'Rokkitt',
    'Karla:400,400italic,700'                                       => 'Karla',
    'Quicksand:400,700'                                             => 'Quicksand',
    'Andada'                                                        => 'Andada',
    'Varela+Round'                                                  => 'Varela Round',
    'Bangers'                                                       => 'Bangers',
    'Righteous'                                                     => 'Righteous',
    'PT+Sans+Caption:400,700'                                       => 'PT Sans Caption',
    'Dancing+Script:400,700'                                        => 'Dancing Script',
    'Monda:400,700'                                                 => 'Monda',
    'Exo:400,300,400italic,600,800'                                 => 'Exo',
    'Abril+Fatface'                                                 => 'Abril Fatface',
    'Pathway+Gothic+One'                                            => 'Pathway Gothic One',
    'Questrial'                                                     => 'Questrial',
    'Josefin+Slab:400,400italic,700,600'                            => 'Josefin Slab',
    'Istok+Web:400,400italic,700'                                   => 'Istok Web',
    'Patua+One'                                                     => 'Patua One',
    'News+Cycle:400,700'                                            => 'News Cycle',
    'BenchNine:400,700'                                             => 'BenchNine',
    'Ropa+Sans:400,400italic'                                       => 'Ropa Sans',
    'Crete+Round:400,400italic'                                     => 'Crete Round',
    'Covered+By+Your+Grace'                                         => 'Covered By Your Grace',
    'Hammersmith+One'                                               => 'Hammersmith One',
    'Quattrocento+Sans:400,700,400italic'                           => 'Quattrocento Sans',
    'Pontano+Sans'                                                  => 'Pontano Sans',
    'Fredoka+One'                                                   => 'Fredoka One',
    'EB+Garamond'                                                   => 'EB Garamond',
    'Old+Standard +TT:400,400italic,700'                            => 'Old Standard TT',
    'Noticia+Text:400,400italic,700'                                => 'Noticia Text',
    'Kaushan+Script'                                                => 'Kaushan Script',
    'Voltaire'                                                      => 'Voltaire',
    'ABeeZee:400,400italic'                                         => 'ABeeZee',
    'Comfortaa:400,300,700'                                         => 'Comfortaa',
    'Russo+One'                                                     => 'Russo One',
    'Cinzel:400,700,900'                                            => 'Cinzel',
    'Sanchez:400,400italic'                                         => 'Sanchez',
    'Lobster+Two:400,700,700italic'                                 => 'Lobster Two',
    'Alfa+Slab+One'                                                 => 'Alfa Slab One',
    'Passion+One:400,700,900'                                       => 'Passion One',
    'Cantarell:400,400italic,700'                                   => 'Cantarell',
    'Tinos:400,400italic,700'                                       => 'Tinos',
    'Lateef'                                                        => 'Lateef',
    'Archivo+Black'                                                 => 'Archivo Black',
    'Cabin+Condensed:400,500,600,700'                               => 'Cabin Condensed',
    'Satisfy'                                                       => 'Satisfy',
    'Bevan'                                                         => 'Bevan',
    'Economica:400,700,400italic'                                   => 'Economica',
    'Playball'                                                      => 'Playball',
    'Kreon:400,300,700'                                             => 'Kreon',
    'Didact+Gothic'                                                 => 'Didact Gothic',
    'Handlee'                                                       => 'Handlee',
    'Cookie'                                                        => 'Cookie',
    'Jura:400,300,500,600'                                          => 'Jura',
    'Amaranth:400,400italic,700'                                    => 'Amaranth',
    'Fugaz+One'                                                     => 'Fugaz One',
    'Tangerine:400,700'                                             => 'Tangerine',
    'Squada+One'                                                    => 'Squada One',
    'Great+Vibes'                                                   => 'Great Vibes',
    'Six+Caps'                                                      => 'Six Caps',
    'Limelight'                                                     => 'Limelight',
    'Carme'                                                         => 'Carme',
    'Cherry+Cream+Soda'                                             => 'Cherry Cream Soda',
    'Aldrich'                                                       => 'Aldrich',
    'Alex+Brush'                                                    => 'Alex Brush',
    'Fredericka+the+Great'                                          => 'Fredericka the Great'
);

function blog_kit_customize_register( $wp_customize ) {

	global $blog_kit_google_fonts;

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        		=> '.site-title a',
			'container_inclusive' 	=> false,
			'render_callback' 	    => 'blog_kit_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        		=> '.site-description',
			'container_inclusive' 	=> false,
			'render_callback' 		=> 'blog_kit_customize_partial_blogdescription',
		) );
	}

	// Sanitization.
	require_once trailingslashit( get_template_directory() ) . '/inc/sanitize.php';

	//Color Options Setting Starts
	// Setting site primary color.
	$wp_customize->add_setting( 'theme_options[primary_color]',
		array(
			'default'           => '#33b7ff',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'theme_options[primary_color]',
			array(
				'label'       => esc_html__( 'Primary Color', 'blog-kit' ),
				'section'     => 'colors',	
			)
		)
	);

	// Setting site secondary color.
	$wp_customize->add_setting( 'theme_options[secondary_color]',
		array(
			'default'           => '#fe6619',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'theme_options[secondary_color]',
			array(
				'label'       => esc_html__( 'Secondary Color', 'blog-kit' ),
				'section'     => 'colors',	
			)
		)
	);

	//Logo Options Setting Starts
	$wp_customize->add_setting('theme_options[site_identity]', 
		array(
			'default' 			=> 'title-text',
			'sanitize_callback' => 'blog_kit_sanitize_select'
		)
	);

	$wp_customize->add_control('theme_options[site_identity]', 
		array(
			'type' 		=> 'radio',
			'label' 	=> esc_html__('Logo Options', 'blog-kit'),
			'section' 	=> 'title_tagline',
			'choices' 	=> array(
				'logo-only' 	=> esc_html__('Logo Only', 'blog-kit'),
				'title-only' 	=> esc_html__('Title Only', 'blog-kit'),
				'title-text' 	=> esc_html__('Title + Tagline', 'blog-kit'),
				)
		)
	);
	
	// Add Theme Options Panel.
	$wp_customize->add_panel( 'theme_option_panel',
		array(
			'title'      => esc_html__( 'Theme Options', 'blog-kit' ),
			'priority'   => 100,
		)
	);

	// Header Section.
	$wp_customize->add_section( 'section_header',
		array(
			'title'      => esc_html__( 'Header', 'blog-kit' ),
			'priority'   => 100,
			'panel'      => 'theme_option_panel',
		)
	);

	// Setting show_social_icons.
	$wp_customize->add_setting( 'theme_options[show_social_icons]',
		array(
			'default'           => false,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[show_social_icons]',
		array(
			'label'    => esc_html__( 'Show Social Icons', 'blog-kit' ),
			'section'  => 'section_header',
			'type'     => 'checkbox',
			'priority' => 100,
		)
	);

	// Layout Blog/Archive Section.
	$wp_customize->add_section( 'section_layout',
		array(
			'title'      => esc_html__( 'Blog/Archive Layouts', 'blog-kit' ),
			'priority'   => 100,
			'panel'      => 'theme_option_panel',
		)
	);

	// Setting global_layout.
	$wp_customize->add_setting( 'theme_options[global_layout]',
		array(
			'default'           => 'right-sidebar',
			'sanitize_callback' => 'blog_kit_sanitize_select',
		)
	);
	$wp_customize->add_control( 'theme_options[global_layout]',
		array(
			'label'    => esc_html__( 'Default Sidebar Layout', 'blog-kit' ),
			'section'  => 'section_layout',
			'type'     => 'radio',
			'priority' => 100,
			'choices'  => array(
					'left-sidebar'  => esc_html__( 'Sidebar / Content', 'blog-kit' ),
					'right-sidebar' => esc_html__( 'Content / Sidebar', 'blog-kit' ),
				),
		)
	);

	// Setting blog_post_structure.
	$wp_customize->add_setting( 'theme_options[blog_post_structure]',
		array(
			'default'           => 'style-1',
			'sanitize_callback' => 'blog_kit_sanitize_select',
		)
	);

	$wp_customize->add_control( new Blog_Kit_Image_Radio_Control($wp_customize, 'theme_options[blog_post_structure]',
		array(
	        'label'    	=> esc_html__( 'Blog Post Structure', 'blog-kit' ),
	        'section' 	=> 'section_layout',
	        'type' 		=> 'radio-image',
	        'priority'  => 100,
	        'choices' 	=> array(
								'style-1' => array(
									'label' => esc_html__( 'One', 'blog-kit' ),
									'url'   => get_template_directory_uri() . '/inc/assets/images/blog-1.jpg',
								),
								'style-2' => array(
									'label' => esc_html__( 'Two', 'blog-kit' ),
									'url'   => get_template_directory_uri() . '/inc/assets/images/blog-2.jpg',
								),
							)
	    )
	));

	// Setting excerpt_length.
	$wp_customize->add_setting( 'theme_options[excerpt_length]',
		array(
			'default'           => 40,
			'sanitize_callback' => 'absint',
		)
	);
	$wp_customize->add_control( 'theme_options[excerpt_length]',
		array(
			'label'       => esc_html__( 'Excerpt Length', 'blog-kit' ),
			'section'     => 'section_layout',
			'type'        => 'number',
			'priority'    => 100,
			'input_attrs' => array( 'min' => 1, 'max' => 500, 'style' => 'width: 55px;' ),
		)
	);

	// Setting readmore_text.
	$wp_customize->add_setting( 'theme_options[readmore_text]',
		array(
			'default'           => esc_html__( 'Read More', 'blog-kit' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control( 'theme_options[readmore_text]',
		array(
			'label'    => esc_html__( 'Read More Text', 'blog-kit' ),
			'section'  => 'section_layout',
			'type'     => 'text',
			'priority' => 100,
		)
	);

	// Setting blog_posted_date.
	$wp_customize->add_setting( 'theme_options[blog_post_date]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[blog_post_date]',
		array(
			'label'    			=> esc_html__( 'Show Published Date', 'blog-kit' ),
			'section'  			=> 'section_layout',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting blog_post_author.
	$wp_customize->add_setting( 'theme_options[blog_post_author]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[blog_post_author]',
		array(
			'label'    			=> esc_html__( 'Show Author', 'blog-kit' ),
			'section'  			=> 'section_layout',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting blog_post_category.
	$wp_customize->add_setting( 'theme_options[blog_post_category]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[blog_post_category]',
		array(
			'label'    			=> esc_html__( 'Show Category', 'blog-kit' ),
			'section'  			=> 'section_layout',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting blog_post_comment.
	$wp_customize->add_setting( 'theme_options[blog_post_comment]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[blog_post_comment]',
		array(
			'label'    			=> esc_html__( 'Show Comments', 'blog-kit' ),
			'section'  			=> 'section_layout',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Layout Single Post Section.
	$wp_customize->add_section( 'section_single',
		array(
			'title'      => esc_html__( 'Single Post Layouts', 'blog-kit' ),
			'priority'   => 100,
			'panel'      => 'theme_option_panel',
		)
	);

	// Setting single_post_structure.
	$wp_customize->add_setting( 'theme_options[single_post_structure]',
		array(
			'default'           => 'style-1',
			'sanitize_callback' => 'blog_kit_sanitize_select',
		)
	);

	$wp_customize->add_control( new Blog_Kit_Image_Radio_Control($wp_customize, 'theme_options[single_post_structure]',
		array(
	        'label'    	=> esc_html__( 'Single Post Structure', 'blog-kit' ),
	        'section' 	=> 'section_single',
	        'type' 		=> 'radio-image',
	        'priority'  => 100,
	        'choices' 	=> array(
								'style-1' => array(
									'label' => esc_html__( 'One', 'blog-kit' ),
									'url'   => get_template_directory_uri() . '/inc/assets/images/blog-1.jpg',
								),
								'style-2' => array(
									'label' => esc_html__( 'Two', 'blog-kit' ),
									'url'   => get_template_directory_uri() . '/inc/assets/images/blog-2.jpg',
								),
							)
	    )
	));

	// Setting blog_posted_date.
	$wp_customize->add_setting( 'theme_options[single_post_date]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[single_post_date]',
		array(
			'label'    			=> esc_html__( 'Show Published Date', 'blog-kit' ),
			'section'  			=> 'section_single',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting single_post_author.
	$wp_customize->add_setting( 'theme_options[single_post_author]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[single_post_author]',
		array(
			'label'    			=> esc_html__( 'Show Author', 'blog-kit' ),
			'section'  			=> 'section_single',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting single_post_category.
	$wp_customize->add_setting( 'theme_options[single_post_category]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[single_post_category]',
		array(
			'label'    			=> esc_html__( 'Show Category', 'blog-kit' ),
			'section'  			=> 'section_single',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting single_post_comment.
	$wp_customize->add_setting( 'theme_options[single_post_comment]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[single_post_comment]',
		array(
			'label'    			=> esc_html__( 'Show Comments', 'blog-kit' ),
			'section'  			=> 'section_single',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Setting single_post_tag.
	$wp_customize->add_setting( 'theme_options[single_post_tag]',
		array(
			'default'           => true,
			'sanitize_callback' => 'blog_kit_sanitize_checkbox',
		)
	);
	$wp_customize->add_control( 'theme_options[single_post_tag]',
		array(
			'label'    			=> esc_html__( 'Show Tags', 'blog-kit' ),
			'section'  			=> 'section_single',
			'type'     			=> 'checkbox',
			'priority' 			=> 100,
		)
	);

	// Footer Section.
	$wp_customize->add_section( 'section_footer',
		array(
			'title'      => esc_html__( 'Footer', 'blog-kit' ),
			'priority'   => 100,
			'panel'      => 'theme_option_panel',
		)
	);

	// Setting copyright_text.
	$wp_customize->add_setting( 'theme_options[copyright_text]',
		array(
			'default'           => esc_html__( 'Copyright © All rights reserved.', 'blog-kit' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control( 'theme_options[copyright_text]',
		array(
			'label'    => esc_html__( 'Copyright Text', 'blog-kit' ),
			'section'  => 'section_footer',
			'type'     => 'text',
			'priority' => 100,
		)
	);

	// Setting powerby_text.
	$wp_customize->add_setting( 'theme_options[powerby_text]',
		array(
			'default'           => esc_html__( 'Blog Kit Pro by', 'blog-kit' ) . ' <a target="_blank" rel="nofollow" href="https://wpcharms.com/">WP Charms</a>',
			'sanitize_callback' => 'blog_kit_sanitize_credit',
		)
	);
	$wp_customize->add_control( 'theme_options[powerby_text]',
		array(
			'label'    => esc_html__( 'Powerby Text', 'blog-kit' ),
			'section'  => 'section_footer',
			'type'     => 'textarea',
			'priority' => 100,
		)
	);

	// Fonts Section.
	$wp_customize->add_section( 'section_fonts',
		array(
			'title'      => esc_html__( 'Fonts', 'blog-kit' ),
			'priority'   => 100,
			'panel'      => 'theme_option_panel',
		)
	);

	// Setting body_font.
	$wp_customize->add_setting( 'theme_options[body_font]',
		array(
			'default'           => 'Roboto:400,500,300,700,400italic',
			'sanitize_callback' => 'blog_kit_sanitize_select',
		)
	);
	$wp_customize->add_control( 'theme_options[body_font]',
		array(
			'label'       => esc_html__( 'Body Font', 'blog-kit' ),
			'section'     => 'section_fonts',
			'type'        => 'select',
			'choices'     => $blog_kit_google_fonts,
		)
	);

	// Setting heading_font.
	$wp_customize->add_setting( 'theme_options[heading_font]',
		array(
			'default'           => 'Roboto:400,500,300,700,400italic',
			'sanitize_callback' => 'blog_kit_sanitize_select',
		)
	);
	$wp_customize->add_control( 'theme_options[heading_font]',
		array(
			'label'       => esc_html__( 'Headings Font', 'blog-kit' ),
			'section'     => 'section_fonts',
			'type'        => 'select',
			'choices'     => $blog_kit_google_fonts,
		)
	);

}

add_action( 'customize_register', 'blog_kit_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function blog_kit_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function blog_kit_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Enqueue style for custom customize control.
 */

function blog_kit_custom_customizer_scripts() {

	wp_enqueue_style( 'blog-kit-customize', get_template_directory_uri() . '/inc/assets/customize-controls.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'blog_kit_custom_customizer_scripts' );