<?php
/**
 * Dynamic Options hook.
 *
 * This file contains option values from customizer
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Blog_Kit
 */

if ( ! function_exists( 'blog_kit_dynamic_styles' ) ) :

    function blog_kit_dynamic_styles(){

        global $blog_kit_google_fonts;

        //fonts
        $body_font          =  blog_kit_get_option( 'body_font' );
        $heading_font       =  blog_kit_get_option( 'heading_font' );

        //colors
        $primary_color      =  blog_kit_get_option( 'primary_color' );
        $secondary_color    =  blog_kit_get_option( 'secondary_color' );

        ?>               
            
        <style type="text/css">

            body,
            p,
            li,
            .main-navigation ul li a,
            .button,
            input[type="submit"],
            .table thead th,
            .table tbody tr td,
            .side-bar .widget ul li,
            .side-bar .widget ul li a,
            .tagcloud a {
                font-family: '<?php echo esc_attr( $blog_kit_google_fonts[$body_font] ); ?>';
            }

            h1, h1 a,
            h2, h2 a,
            h3, h3 a,
            h4, h4 a,
            h5, h5 a,
            h6, h6 a{
                font-family: '<?php echo esc_attr( $blog_kit_google_fonts[$heading_font] ); ?>';
            }

            .main-navigation ul li.current-menu-item a, 
            .main-navigation ul li a:hover{
                color: <?php echo esc_attr( $primary_color ); ?>;
            }

            button, 
            .comment-reply-link, 
            a.button, input[type="button"], 
            input[type="reset"], 
            input[type="submit"],
            .blog-item .blog-text-wrap .date-header,
            #sidebar-primary .widget .widget-title:after, 
            #primary .page-header .page-title:after,
            .btn-more, 
            #primary .entry-content a.btn-more,
            .pagination .nav-links .page-numbers.current, 
            .pagination .nav-links .page-numbers:hover,
            .error-404.not-found form.search-form input[type="submit"], 
            .search-no-results .no-results.not-found form.search-form input[type="submit"]{
                background: <?php echo esc_attr( $primary_color ); ?>;
            }

            .entry-meta > span::before, 
            .entry-footer > span::before, 
            .single-post-meta > span::before,
            .nav-links .nav-previous a:hover, 
            .nav-links .nav-next a:hover,
            .comment-navigation .nav-next a:hover:after, 
            .comment-navigation .nav-previous a:hover:before, 
            .nav-links .nav-previous a:hover:before, 
            .nav-links .nav-next a:hover:after,
            .comment-meta .comment-author a.url,
            .comment-meta .comment-metadata a,
            .comment .comment-body .comment-content a,
            .comments-area form#commentform p.logged-in-as a,
            .entry-content a,
            .post-navigation .nav-links .nav-previous:hover a, 
            .post-navigation .nav-links .nav-next:hover a, 
            .post-navigation .nav-links .nav-previous:hover:before, 
            .post-navigation .nav-links .nav-next:hover:after,
            .main-navigation ul li ul li a:hover{
                color: <?php echo esc_attr( $primary_color ); ?>;
            }

            .pagination .nav-links .page-numbers,
            .nav-links .page-numbers.current, 
            .nav-links a.page-numbers:hover {
                border: 1px solid <?php echo esc_attr( $primary_color ); ?>;
            }

            blockquote {
                border-bottom: 2px solid <?php echo esc_attr( $primary_color ); ?>;
            }

            .side-bar .widget-title:after,
            .footer-widgets h2.widget-title:after {
                background: <?php echo esc_attr( $primary_color ); ?>;
                border-right: 25px solid <?php echo esc_attr( $secondary_color ); ?>;
            }

            .button:hover, 
            button:hover,
            input[type="button"]:hover,
            input[type="reset"]:hover,
            input[type="submit"]:hover,
            a.comment-reply-link:hover,
            .error-404.not-found  form.search-form input[type="submit"]:hover,
            .search-no-results .no-results.not-found form.search-form input[type="submit"]:hover,
            .btn-more:hover,
            #primary .entry-content a.btn-more:hover {
                background: <?php echo esc_attr( $secondary_color ); ?>;
            }

            #primary .entry-content a {
                color: <?php echo esc_attr( $secondary_color ); ?>;
            }

        </style>

        <?php
    }

endif;

add_action( 'wp_head', 'blog_kit_dynamic_styles' );